<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Services\Registration;
use App\Imports\TrainerImport;
use App\Models\Trainer;
use App\Models\User;
use Illuminate\Http\Request;

class TrainerController extends Controller
{
    public function index()
    {
        $trainers = User::train()->with('trainer')->get();
        return view('trainers.list')->with('trainers', $trainers);
    }
    public function store(Request $request)
    {
        // return $request;
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users',
        ], [
            'name.required' => 'يرجى اضافة الاسم .',
            'email.required' => 'يرجى اضافة الإيميل .',
            'email.email' => 'يرجى اضافة إيميل صحيح .',
            'email.unique' => 'هذا الإيميل مستخدم من قبل  .']);
        try {

            $newTrainer = new User();
            $newTrainer->name = $request->name;
            $newTrainer->email = $request->email;
            if (!$request->phone == null) {
                $newTrainer->phone = $request->phone;
            }
            $newTrainer->role = 1;
            $newTrainer->save();
            // if (!$request->description == null) {
            //     $newTrainer->trainer()->create([
            //         'trainer_id' => $newTrainer->id,
            //         'description' => $request->description,
            //     ]);
            // }

            if (Registration::sendMails($newTrainer)) {
                return back()->with(['success' => 'تم إضافة بيانات المشرف بنجاح']);
            }
            return back()->with(['warning' => 'تم إضافة بيانات المشرف ولم يرسل ايميل التفعيل']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم إضافة بيانات المشرف  ']);
        }
    }

    public function update(Request $request)
    {
        try {
        //    return $request->description;
            $updateTrainer = User::find($request->id);
            $updateTrainer->name = $request->name;
            $updateTrainer->email = $request->email;
            if (!$request->phone == null) 
                $updateTrainer->phone = $request->phone;
            
            $updateTrainer->update();
            // if (!$request->description == null) {
            //  $trainerInfo = Trainer::where('trainer_id', $updateTrainer->id)->first();
            //     if($trainerInfo == null)
            //     {
            //         $updateTrainer->trainer()->create([
            //             'trainer_id' => $updateTrainer->id,
            //             'description' => $request->description,
            //         ]);
            //     }
            //     else{
            //         $trainerInfo->description = $request->description;
            //     }
            // $trainerInfo->update();
            


            return back()->with(['success' => 'تم تحديث بيانات المشرف بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم تحديث البيانات ']);
        }

}
    public function delete(Request $request)
    {
        // return $request;
        try {
            User::find($request->id)->delete();
            return back()->with(['success' => 'تمت حذف المشرف بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم حذف المشرف ']);
        }
    }
    /**
     * [Active and not active ]
     *
     * @param Request $request
     * 
     * @return [type]
     * 
     */
    public function toggle(Request $request)
    {
        try {
            $student = User::find($request->id);
            $student->is_active *= -1;
            $student->save();
            return back()->with(['success' => 'تمت تحديث البيانات بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم تحديث البيانات']);
        }
    }
    /**
     * [Description for import]
     *
     * @param Request $request
     *
     * @return [type]
     *
     */
    public function import(Request $request)
    {
        $request->validate([
            'trainerFile' => 'required|mimes:xlsx',
        ], [
            'trainerFile.required' => 'يرجى ارفاق الملف',
            'trainerFile.mimes' => 'يرجى التاكد من صيفة الملف',
        ]);
        try {
            $file = $request->file('trainerFile');
            $import = new TrainerImport();
            $import->import($file);

            if ($import->failures()->isNotEmpty()) {
                return back()->with(['import_errors' => $import->failures()]);
            }
            //call method wih  send email
            return back()->with(['success' => ' تم استيراد الملف ونعمل حاليا على تخزينها في قاعدة البيانات ,سيتم ارسال اشعار اذا كان هناك خطاء']);
        } catch (\Maatwebsite\Excel\Validators\ValidationException$e) {
            $failures = $e->failures();
            return back()->with(['import_errors' => $failures]);
        }

    }

}
